/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import java.util.Map;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.StepStateLight;

import static com.xebialabs.xltype.serialization.xstream.Converters.writeNode;


public abstract class AbstractStepConverter implements Converter {

    private static final XmlSanitizer sanitizer = new XmlSanitizer();

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        StepState s = (StepState) source;
        if(s.getFailureCount() != -1){
            writer.addAttribute("failures", Integer.toString(s.getFailureCount()));
        }
        writer.addAttribute("state", s.getState().name());
        writer.addAttribute("skippable", Boolean.toString(s.getSkippable()));

        if (s instanceof StepStateLight) {
            writer.addAttribute("description", s.getDescription());
        } else {
            writeNode("description", s.getDescription(), writer);
        }
        if (s.getStartDate() != null) {
            writeNode("startDate", new DateTimeAdapter().marshal(s.getStartDate()), writer);
        }
        if (s.getCompletionDate() != null) {
            writeNode("completionDate", new DateTimeAdapter().marshal(s.getCompletionDate()), writer);
        }
        if (s.getPreviousAttemptsLogs() != null) {
            writer.startNode("previousAttemptslogs");
            s.getPreviousAttemptsLogs().forEach(log -> writeNode("log", sanitizer.sanitize(log), writer));
            writer.endNode();
        }
        if (s.getLog() != null) {
            writeNode("log", sanitizer.sanitize(s.getLog()), writer);
        }

        if(s.getMetadata() != null){
            Map<String, String> metadata = s.getMetadata();
            writer.startNode("metadata");
            for (Map.Entry<String, String> e : metadata.entrySet()) {
                writeNode(e.getKey(), e.getValue(), writer);
            }
            writer.endNode();
        }

    }

    @Override
    public boolean canConvert(Class type) {
        return StepState.class.isAssignableFrom(type);
    }
}
