/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.FetchMode;
import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.SerializableTask;
import com.xebialabs.deployit.engine.api.execution.TaskPackageDependency;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.Map;

public abstract class AbstractTaskWithBlockConverter
implements Converter {
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TaskWithBlock task = (TaskWithBlock)source;
        writer.addAttribute("id", task.getId());
        writer.addAttribute("failures", Integer.toString(task.getFailureCount()));
        if (task.getState() != null) {
            writer.addAttribute("state", task.getState().name());
        }
        writer.addAttribute("owner", task.getOwner());
        if (task.getWorkerId() != null) {
            writer.addAttribute("workerId", task.getWorkerId().toString());
        }
        if (task.getBlock() != null) {
            writer.addAttribute("type", FetchMode.FULL.name());
        } else {
            writer.addAttribute("type", FetchMode.SUMMARY.name());
        }
        Converters.writeNode("description", task.getDescription(), writer);
        if (task.getStartDate() != null) {
            Converters.writeNode("startDate", new DateTimeAdapter().marshal(task.getStartDate()), writer);
        }
        if (task.getCompletionDate() != null) {
            Converters.writeNode("completionDate", new DateTimeAdapter().marshal(task.getCompletionDate()), writer);
        }
        if (task.getScheduledDate() != null) {
            Converters.writeNode("scheduledDate", new DateTimeAdapter().marshal(task.getScheduledDate()), writer);
        }
        writer.startNode("activeBlocks");
        if (task.getActiveBlocks() != null) {
            for (String current : task.getActiveBlocks()) {
                if (current == null) continue;
                Converters.writeNode("active", current, writer);
            }
        }
        writer.endNode();
        Map metadata = task.getMetadata();
        writer.startNode("metadata");
        for (Map.Entry e : metadata.entrySet()) {
            Converters.writeNode((String)e.getKey(), (String)e.getValue(), writer);
        }
        writer.endNode();
        if (task.getBlock() != null) {
            this.writePhaseContainer(writer, context, task);
        }
        if (task.getPackageDependencies() != null) {
            this.writeTaskPackageDependencies(writer, (SerializableTask)task);
        }
    }

    protected void writePhaseContainer(HierarchicalStreamWriter writer, MarshallingContext context, TaskWithBlock task) {
        writer.startNode("block");
        Converters.writePhaseContainer((PhaseContainerState)task.getBlock(), writer, context, false);
        writer.endNode();
    }

    protected void writeTaskPackageDependencies(HierarchicalStreamWriter writer, SerializableTask task) {
        writer.startNode("dependencies");
        for (TaskPackageDependency dependency : task.getPackageDependencies()) {
            writer.startNode("dependency");
            Converters.writeNode("application", dependency.getApplication(), writer);
            Converters.writeNode("version", dependency.getVersion(), writer);
            writer.endNode();
        }
        writer.endNode();
    }

    public boolean canConvert(Class type) {
        return TaskWithBlock.class.isAssignableFrom(type);
    }
}

