/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization;

import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;

public interface CiReader {

    String getType();
    String getId();
    String getToken();
    CiAttributes getCiAttributes();

    boolean hasMoreProperties();
    void moveIntoProperty();
    CiReader moveIntoNestedProperty();
    void moveOutOfProperty();

    String getCurrentPropertyName();
    String getStringValue();
    List<String> getStringValues();
    Map<String, String> getStringMap();
    boolean isCiReference();
    String getCiReference();
    List<String> getCiReferences();

    CiListReader getCurrentCiListReader();

    List<ValidationMessage> getValidationMessages();

}
