/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.reflection.ReflectionConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XmlFriendlyNameCoder;
import com.thoughtworks.xstream.io.xml.XppDriver;
import com.thoughtworks.xstream.security.AnyTypePermission;
import com.thoughtworks.xstream.security.NoTypePermission;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.xstream.ConfigurationItemCollectionConverter;
import com.xebialabs.xltype.serialization.xstream.ConfigurationItemMarshallingStrategy;
import com.xebialabs.xltype.serialization.xstream.XStreamProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import nl.javadude.scannit.Scannit;
import org.jboss.resteasy.util.Types;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Produces(value={"application/*+xml", "text/*+xml"})
@Consumes(value={"application/*+xml", "text/*+xml"})
public class XStreamReaderWriter
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    public static final XppDriver HIERARCHICAL_STREAM_DRIVER = new XppDriver((NameCoder)new XmlFriendlyNameCoder("_-", "_")){

        public HierarchicalStreamWriter createWriter(Writer out) {
            return new PrettyPrintWriter(out, PrettyPrintWriter.XML_1_1, this.getNameCoder());
        }
    };
    private static final XStream xStream = new XStreamWithoutReflectionConverter(HIERARCHICAL_STREAM_DRIVER);
    private static final AtomicReference<List<Converter>> CONVERTERS = new AtomicReference(new ArrayList());
    private static final Logger logger = LoggerFactory.getLogger(XStreamReaderWriter.class);

    public XStreamReaderWriter() {
        logger.debug("Created XStreamReaderWriter");
        this.init();
    }

    protected void init() {
        Collection<Converter> converters = this.allConverters();
        for (Converter converter : converters) {
            XStreamReaderWriter.registerConverter(converter);
        }
    }

    public static void registerConverter(Converter converter) {
        xStream.registerConverter(converter);
        XStreamProvider annotation = converter.getClass().getAnnotation(XStreamProvider.class);
        xStream.aliasType(annotation.tagName(), annotation.readable());
        CONVERTERS.get().add(converter);
    }

    public static void registerConfigurationItemAliases() {
        xStream.registerConverter((Converter)new ConfigurationItemCollectionConverter(xStream.getMapper()));
        xStream.setMarshallingStrategy((MarshallingStrategy)new ConfigurationItemMarshallingStrategy(1003));
        for (Descriptor descriptor : DescriptorRegistry.getDescriptors()) {
            xStream.aliasType(descriptor.getType().toString(), ConfigurationItem.class);
        }
    }

    private Collection<Converter> allConverters() {
        Set classes = Scannit.getInstance().getTypesAnnotatedWith(XStreamProvider.class);
        ArrayList<Converter> converters = new ArrayList<Converter>();
        for (Class aClass : classes) {
            if (!Converter.class.isAssignableFrom(aClass)) {
                throw new IllegalArgumentException(String.format("Class annotated with %s is not a %s", XStreamProvider.class, Converter.class));
            }
            converters.add(this.constructConverter(aClass));
        }
        return converters;
    }

    protected Converter constructConverter(Class<?> clazz) {
        try {
            return (Converter)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isForRegisteredConverter(type, genericType);
    }

    protected boolean isForRegisteredConverter(Class<?> type, Type genericType) {
        if (Collection.class.isAssignableFrom(type) && genericType != null) {
            logger.trace("Is a collection of: {}", (Object)genericType);
            Class baseType = Types.getCollectionBaseType(type, (Type)genericType);
            return baseType != null && this.canBeConverted(baseType);
        }
        if (Map.class.isAssignableFrom(type) && genericType != null) {
            logger.trace("Is a collection of: {}", (Object)genericType);
            Class keyClass = Types.getMapKeyType((Type)genericType);
            Class valueClass = Types.getMapValueType((Type)genericType);
            if (Collection.class.isAssignableFrom(valueClass)) {
                Type valueType = ((ParameterizedType)genericType).getActualTypeArguments()[1];
                Class valueBaseClass = Types.getCollectionBaseType((Class)valueClass, (Type)valueType);
                return valueBaseClass != null && keyClass != null && this.canBeConverted(valueBaseClass) && this.canBeConverted(keyClass);
            }
            return keyClass != null && this.canBeConverted(keyClass) && valueClass != null && this.canBeConverted(valueClass);
        }
        return this.canBeConverted(type);
    }

    private boolean canBeConverted(Class type) {
        for (Converter converter : CONVERTERS.get()) {
            if (!converter.canConvert(type)) continue;
            return true;
        }
        boolean canConvert = Arrays.asList(String.class, Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class).contains(type);
        return canConvert;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        logger.trace("Reading {}", (Object)genericType);
        return xStream.unmarshal(HIERARCHICAL_STREAM_DRIVER.createReader(entityStream), null, this.createDataHolder());
    }

    protected DataHolder createDataHolder() {
        return null;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        logger.trace("Checking writeable: {} - {}", type, (Object)genericType);
        return this.isForRegisteredConverter(type, genericType);
    }

    public long getSize(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object o, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        logger.trace("Writing {}", (Object)genericType);
        xStream.toXML(o, (Writer)new OutputStreamWriter(entityStream, "UTF-8"));
    }

    public static XStream getConfiguredXStream() {
        return xStream;
    }

    static class XStreamWithoutReflectionConverter
    extends XStream {
        public XStreamWithoutReflectionConverter(XppDriver hierarchicalStreamDriver) {
            super((HierarchicalStreamDriver)hierarchicalStreamDriver);
            this.addPermission(NoTypePermission.NONE);
            this.addPermission(AnyTypePermission.ANY);
        }

        public void registerConverter(Converter converter, int priority) {
            if (!(converter instanceof ReflectionConverter)) {
                super.registerConverter(converter, priority);
            }
        }
    }
}

