/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.engine.api.execution.StepStateLight;
import com.xebialabs.xltype.serialization.xstream.Converters;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import com.xebialabs.xltype.serialization.xstream.XmlSanitizer;
import java.util.Map;

public abstract class AbstractStepConverter
implements Converter {
    private static final XmlSanitizer sanitizer = new XmlSanitizer();

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        StepState s = (StepState)source;
        if (s.getFailureCount() != -1) {
            writer.addAttribute("failures", Integer.toString(s.getFailureCount()));
        }
        writer.addAttribute("state", s.getState().name());
        writer.addAttribute("skippable", Boolean.toString(s.getSkippable()));
        if (s instanceof StepStateLight) {
            writer.addAttribute("description", s.getDescription());
        } else {
            Converters.writeNode("description", s.getDescription(), writer);
        }
        if (s.getStartDate() != null) {
            Converters.writeNode("startDate", new DateTimeAdapter().marshal(s.getStartDate()), writer);
        }
        if (s.getCompletionDate() != null) {
            Converters.writeNode("completionDate", new DateTimeAdapter().marshal(s.getCompletionDate()), writer);
        }
        if (s.getLog() != null) {
            Converters.writeNode("log", sanitizer.sanitize(s.getLog()), writer);
        }
        if (s.getMetadata() != null) {
            Map metadata = s.getMetadata();
            writer.startNode("metadata");
            for (Map.Entry e : metadata.entrySet()) {
                Converters.writeNode((String)e.getKey(), (String)e.getValue(), writer);
            }
            writer.endNode();
        }
    }

    public boolean canConvert(Class type) {
        return StepState.class.isAssignableFrom(type);
    }
}

