/**
 * Copyright 2014-2018 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.dto.SatelliteInfo;

public class SatelliteInfoJsonConverter {

    public String toJson(SatelliteInfo satelliteInfo) {
        JsonWriter writer = new JsonWriter();
        toJson(satelliteInfo, writer);
        return writer.toString();
    }

    public void toJson(final SatelliteInfo satelliteInfo, final JsonWriter writer) {
        writer.object();
        writer.key("version").value(satelliteInfo.getVersion());
        writer.key("available").value(satelliteInfo.isAvailable());
        writer.key("plugins-synced").value(satelliteInfo.arePluginsSynced());
        writer.endObject();
    }
}
