/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.xltype.serialization.json.Converters;
import com.xebialabs.xltype.serialization.json.JsonConverter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.Map;

public class TaskWithBlockJsonConverter
extends JsonConverter<TaskWithBlock> {
    private final DateTimeAdapter timeAdapter = new DateTimeAdapter();

    @Override
    public JsonWriter writeJsonObject(TaskWithBlock taskWithBlock, JsonWriter writer) {
        writer.object();
        writer.key("id").value(taskWithBlock.getId());
        writer.key("failures").value(taskWithBlock.getFailureCount());
        writer.key("owner").value(taskWithBlock.getOwner());
        writer.key("state").value(taskWithBlock.getState());
        if (taskWithBlock.getDescription() != null) {
            writer.key("description").value(taskWithBlock.getDescription());
        }
        if (taskWithBlock.getStartDate() != null) {
            writer.key("startDate").value(this.timeAdapter.marshal(taskWithBlock.getStartDate()));
        }
        if (taskWithBlock.getCompletionDate() != null) {
            writer.key("completionDate").value(this.timeAdapter.marshal(taskWithBlock.getCompletionDate()));
        }
        if (taskWithBlock.getScheduledDate() != null) {
            writer.key("scheduledDate").value(this.timeAdapter.marshal(taskWithBlock.getScheduledDate()));
        }
        if (taskWithBlock.getActiveBlocks() != null && !taskWithBlock.getActiveBlocks().isEmpty()) {
            writer.key("activeBlocks");
            writer.array();
            for (String string : taskWithBlock.getActiveBlocks()) {
                writer.value(string);
            }
            writer.endArray();
        }
        if (taskWithBlock.getMetadata() != null && !taskWithBlock.getMetadata().isEmpty()) {
            writer.key("metadata").object();
            for (Map.Entry entry : taskWithBlock.getMetadata().entrySet()) {
                writer.key((String)entry.getKey()).value(entry.getValue());
            }
            writer.endObject();
        }
        if (taskWithBlock.getBlock() != null) {
            this.writeBlock(taskWithBlock.getBlock(), writer);
        }
        writer.endObject();
        return writer;
    }

    private void writeBlock(BlockState task, JsonWriter writer) {
        writer.key("block");
        Converters.writeBlockTree(task, writer, false);
    }
}

