/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import com.xebialabs.deployit.engine.api.dto.Inspection;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;

import static com.xebialabs.xltype.serialization.json.Converters.checkArgument;

public class InspectionJsonConverter {

    private final ConfigurationItemConverter ciConverter;

    public InspectionJsonConverter(ConfigurationItemConverter converter) {
        this.ciConverter = converter;
    }

    public ConfigurationItemConverter getCiConverter() {
        return ciConverter;
    }

    public String toJson(Inspection inspection) {
        JsonWriter writer = new JsonWriter();
        CiWriter ciWriter = new CiJsonWriter(writer);

        writer.object();

        writer.key("inspectable");
        ciConverter.writeCi(inspection.getConfigurationItem(), ciWriter);

        writer.endObject();

        return writer.toString();
    }

    public Inspection toInspection(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);

            checkArgument(json.has("inspectable"), "Missing 'inspectable' property in JSON:\n%s", jsonString);

            ConfigurationItem ci = ciConverter.readCi(new CiJsonReader(json.getJSONObject("inspectable")));

            return new Inspection(ci);

        } catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }
}
