/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.SerializationException;
import com.xebialabs.xltype.serialization.json.CiListJsonReader;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;

public class CiJsonReader
implements CiReader {
    private final JSONObject json;
    private Iterator<String> propertyIterator;
    private String currentPropertyName;

    public CiJsonReader(JSONObject json) {
        this.json = json;
        this.propertyIterator = CiJsonReader.properties(json).iterator();
    }

    public static CiJsonReader create(String jsonObject) {
        try {
            return new CiJsonReader(new JSONObject(jsonObject));
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse the following as a JSON object:\n" + jsonObject, e);
        }
    }

    @Override
    public String getType() {
        try {
            return this.json.getString("type");
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public String getId() {
        try {
            return this.json.getString("id");
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public String getToken() {
        return this.getStringOrNull("$token");
    }

    @Override
    public CiAttributes getCiAttributes() {
        String createdBy = this.getStringOrNull("$createdBy");
        DateTime createdAt = this.getDateTimeOrNull("$createdAt");
        String lastModifiedBy = this.getStringOrNull("$lastModifiedBy");
        DateTime lastModifiedAt = this.getDateTimeOrNull("$lastModifiedAt");
        return new CiAttributes(createdBy, createdAt, lastModifiedBy, lastModifiedAt);
    }

    @Override
    public boolean hasMoreProperties() {
        return this.propertyIterator.hasNext();
    }

    @Override
    public void moveIntoProperty() {
        this.currentPropertyName = this.propertyIterator.next();
    }

    @Override
    public CiReader moveIntoNestedProperty() {
        try {
            return new CiJsonReader(this.json.getJSONObject(this.currentPropertyName));
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public void moveOutOfProperty() {
    }

    @Override
    public String getCurrentPropertyName() {
        return this.currentPropertyName;
    }

    @Override
    public String getStringValue() {
        try {
            return this.json.getString(this.currentPropertyName);
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public List<String> getStringValues() {
        try {
            JSONArray strings = this.json.getJSONArray(this.currentPropertyName);
            return CiJsonReader.toList(strings);
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public Map<String, String> getStringMap() {
        try {
            JSONObject map = this.json.getJSONObject(this.currentPropertyName);
            return CiJsonReader.toMap(map);
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public boolean isCiReference() {
        return this.currentPropertyName != null && this.json.optJSONObject(this.currentPropertyName) == null;
    }

    @Override
    public String getCiReference() {
        return this.getStringValue();
    }

    @Override
    public List<String> getCiReferences() {
        return this.getStringValues();
    }

    @Override
    public CiListReader getCurrentCiListReader() {
        try {
            return new CiListJsonReader(this.json.getJSONArray(this.currentPropertyName));
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public List<ValidationMessage> getValidationMessages() {
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        try {
            JSONArray array = this.json.getJSONArray("validation-messages");
            for (int i = 0; i < array.length(); ++i) {
                messages.add(CiJsonReader.toMessage(array.getJSONObject(i)));
            }
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
        return messages;
    }

    private static Collection<String> properties(JSONObject object) {
        ArrayList<String> properties = new ArrayList<String>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            if (CiJsonReader.isSpecialKey(key)) continue;
            properties.add(key);
        }
        return properties;
    }

    private static boolean isSpecialKey(String key) {
        return "id".equals(key) || "type".equals(key) || key != null && key.startsWith("$");
    }

    private static List<String> toList(JSONArray array) throws JSONException {
        ArrayList<String> strings = new ArrayList<String>(array.length());
        for (int i = 0; i < array.length(); ++i) {
            strings.add(array.getString(i));
        }
        return strings;
    }

    private static Map<String, String> toMap(JSONObject object) throws JSONException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Iterator keys = object.keys();
        while (keys.hasNext()) {
            String key = keys.next().toString();
            map.put(key, object.getString(key));
        }
        return map;
    }

    private static ValidationMessage toMessage(JSONObject jsonObject) throws JSONException {
        return new ValidationMessage(jsonObject.getString("ci"), CiJsonReader.getStringOrNull(jsonObject, "property"), jsonObject.getString("message"), CiJsonReader.getStringOrNull(jsonObject, "level"));
    }

    private String getStringOrNull(String key) {
        return CiJsonReader.getStringOrNull(this.json, key);
    }

    private static String getStringOrNull(JSONObject json, String key) {
        try {
            if (json.has(key)) {
                return json.getString(key);
            }
        }
        catch (JSONException e) {
            throw new SerializationException(e);
        }
        return null;
    }

    private DateTime getDateTimeOrNull(String key) {
        String stringOrNull = this.getStringOrNull(key);
        if (stringOrNull == null) {
            return null;
        }
        return new DateTimeAdapter().unmarshal(stringOrNull);
    }
}

