/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.SerializationException;

public class CiListJsonReader implements CiListReader {

    private Iterator<JSONObject> iterator;
    private JSONObject currentObject;

    public CiListJsonReader(JSONArray json) {
        try {
            this.iterator = toObjectList(json).iterator();
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public static CiListJsonReader create(String jsonArray) {
        try {
            return new CiListJsonReader(new JSONArray(jsonArray));
        } catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse the following as a JSON array:\n" + jsonArray, e);
        }
    }

    //
    // CiListReader implementation
    //

    @Override
    public boolean hasMoreChildren() {
        return iterator.hasNext();
    }

    @Override
    public void moveIntoChild() {
        currentObject = iterator.next();
    }

    @Override
    public void moveOutOfChild() {
        // Noop
    }

    @Override
    public CiReader getCurrentCiReader() {
        CiJsonReader currentReader = new CiJsonReader(currentObject);

        // Unwrap single value, so it can be read by calling CiReader.getStringValue()
        // (Hack to support 'streaming reading' as mandated by the XStream implementation)
        if (currentObject.has("ci-ref")) {
            currentReader.moveIntoProperty();
        }

        return currentReader;
    }


    //
    // Util
    //

    private static List<JSONObject> toObjectList(JSONArray array) throws JSONException {
        List<JSONObject> objects = new ArrayList<>(array.length());
        for (int i = 0; i < array.length(); i++) {
            JSONObject jsonObject = array.optJSONObject(i);

            // Wrap single value into JSONObject
            if (jsonObject == null) {
                jsonObject = new JSONObject();
                // We use a dash in the property name so it won't class with CI properties.
                jsonObject.put("ci-ref", array.getString(i));
            }
            objects.add(jsonObject);
        }

        return objects;
    }

}
