/**
 * Copyright © 2014-2016 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;

public interface CiWriter {

    void startList();
    void endList();
    void startCi(String type, String id);
    void endCi();

    void token(String token);
    void ciAttributes(CiAttributes ciAttributes);
    void ciFileAttribute(String file);

    void startProperty(String name);
    void endProperty();

    void valueAsString(Object value);
    void valuesAsStrings(Collection<?> values);
    void mapAsStrings(Map<?, ?> map);

    void ciReference(String reference);
    void ciReferences(Collection<String> references);
    void typedCiReference(ConfigurationItemId ci);
    void typedCiReferences(Collection<ConfigurationItemId> references);

    void validationMessages(List<ValidationMessage> validations);
}