/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.PhaseContainerState;
import com.xebialabs.deployit.engine.api.execution.PhaseState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Converters {
    public static <T> List<T> readList(Object owner, Class<T> toRead, HierarchicalStreamReader reader, UnmarshallingContext context) {
        ArrayList<Object> list = new ArrayList<Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            list.add(context.convertAnother(owner, toRead));
            reader.moveUp();
        }
        return list;
    }

    public static Map<String, String> readMap(HierarchicalStreamReader reader) {
        HashMap<String, String> map = new HashMap<String, String>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            map.put(reader.getAttribute("key"), reader.getValue());
            reader.moveUp();
        }
        return map;
    }

    public static void writeNode(String name, String value, HierarchicalStreamWriter writer) {
        writer.startNode(name);
        if (value != null) {
            writer.setValue(value);
        }
        writer.endNode();
    }

    public static void writeConfigurationItem(ConfigurationItem ci, HierarchicalStreamWriter writer, MarshallingContext context) {
        writer.startNode(ci.getType().toString());
        context.convertAnother((Object)ci);
        writer.endNode();
    }

    public static void writePhaseContainer(PhaseContainerState phaseContainerState, HierarchicalStreamWriter writer, MarshallingContext context, boolean writeStepBlocks) {
        Converters.writeBlockBasics((BlockState)phaseContainerState, writer);
        writer.addAttribute("root", "true");
        for (PhaseState phase : phaseContainerState.getBlocks()) {
            Converters.writePhase(phase, writer, context, writeStepBlocks);
        }
    }

    public static void writePhase(PhaseState phase, HierarchicalStreamWriter writer, MarshallingContext context, boolean writeStepBlocks) {
        writer.startNode("block");
        Converters.writeBlockBasics((BlockState)phase, writer);
        writer.addAttribute("phase", "true");
        writer.startNode("block");
        Converters.writeBlockTree(phase.getBlock(), writer, context, writeStepBlocks);
        writer.endNode();
        writer.endNode();
    }

    public static void writeBlockTree(BlockState block, HierarchicalStreamWriter writer, MarshallingContext context, boolean writeStepBlocks) {
        if (block instanceof CompositeBlockState) {
            Converters.writeBlockBasics(block, writer);
            CompositeBlockState cbs = (CompositeBlockState)block;
            writer.addAttribute("parallel", String.valueOf(cbs.isParallel()));
            for (BlockState blockState : cbs.getBlocks()) {
                writer.startNode("block");
                Converters.writeBlockTree(blockState, writer, context, writeStepBlocks);
                writer.endNode();
            }
        } else if (writeStepBlocks && block instanceof StepBlockState) {
            Converters.writeStepBlock((StepBlockState)block, writer, context);
        } else if (block instanceof StepBlockState) {
            Converters.writeBlockBasics(block, writer);
        } else {
            throw new IllegalArgumentException("Can only write Composite or Step Blocks, got: " + block);
        }
    }

    public static void writeStepBlock(StepBlockState block, HierarchicalStreamWriter writer, MarshallingContext context) {
        Converters.writeBlockBasics((BlockState)block, writer);
        writer.addAttribute("current", String.valueOf(block.getCurrentStep()));
        Converters.writeSteps(block.getSteps(), writer, context);
    }

    public static void writeSteps(List<StepState> steps, HierarchicalStreamWriter writer, MarshallingContext context) {
        for (StepState step : steps) {
            writer.startNode("step");
            context.convertAnother((Object)step);
            writer.endNode();
        }
    }

    public static void writeBlockBasics(BlockState block, HierarchicalStreamWriter writer) {
        writer.addAttribute("id", block.getId() == null ? "" : block.getId());
        writer.addAttribute("state", block.getState().toString());
        writer.addAttribute("description", block.getDescription());
        writer.addAttribute("hasSteps", block.hasSteps().toString());
    }
}

