/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import java.io.StringWriter;
import java.io.Writer;

import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONWriter;

import com.xebialabs.xltype.serialization.SerializationException;

/**
 * Wraps Jettison's {@link JSONWriter}, but does not throw checked exceptions. All {@link JSONException JSONExceptions}
 * are wrapped by a link {@link SerializationException SerializationExceptions}.
 */
public class JsonWriter {

    private final JSONWriter delegate;
    private final Writer writer;

    public JsonWriter() {
        this(new StringWriter());
    }

    public JsonWriter(Writer writer) {
        this.delegate = new JSONWriter(writer);
        this.writer= writer;
    }

    public Writer getWriter() {
        return writer;
    }

    public JsonWriter array() {
        try {
            delegate.array();
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter endArray() {
        try {
            delegate.endArray();
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter endObject() {
        try {
            delegate.endObject();
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter key(String s) {
        try {
            delegate.key(s);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter object() {
        try {
            delegate.object();
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter value(boolean b) {
        try {
            delegate.value(b);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter value(double b) {
        try {
            delegate.value(b);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter value(long b) {
        try {
            delegate.value(b);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    public JsonWriter value(Object b) {
        try {
            delegate.value(b);
            return this;
        } catch (JSONException e) {
            throw new SerializationException(e);
        }
    }

    @Override
    public String toString() {
        return writer.toString();
    }
}
