/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.CompositeBlockState;
import com.xebialabs.deployit.engine.api.execution.StepBlockState;
import com.xebialabs.deployit.engine.api.execution.StepState;

public class BlockStateJsonConverter extends JsonConverter<BlockState> {

    public JsonWriter writeJsonObject(BlockState block, JsonWriter writer) {
        writer.object();
        writer.key("id").value(block.getId());
        writer.key("state").value(block.getState().name());
        writer.key("description").value(block.getDescription());

        if (block instanceof CompositeBlockState) {
            writeJsonCompositeBlockState((CompositeBlockState) block, writer);
        } else if (block instanceof StepBlockState) {
            writeJsonStepBlockState((StepBlockState) block, writer);
        }

        writer.endObject();

        return writer;
    }

    private void writeJsonStepBlockState(StepBlockState block, JsonWriter writer) {
        writer.key("currentStep").value(block.getCurrentStep());

        if (block.getSteps() != null && !block.getSteps().isEmpty()) {
            StepStateJsonConverter stepStateJsonConverter = new StepStateJsonConverter();
            writer.key("steps").array();
            for (StepState stepState : block.getSteps()) {
                stepStateJsonConverter.writeJsonObject(stepState, writer);
            }
            writer.endArray();
        }
    }

    private void writeJsonCompositeBlockState(CompositeBlockState block, JsonWriter writer) {
        writer.key("parallel").value(block.isParallel());

        if (block.getBlocks() != null && !block.getBlocks().isEmpty()) {
            writer.key("blocks").array();
            for (BlockState blockChild : block.getBlocks()) {
                writeJsonObject(blockChild, writer);
            }
            writer.endArray();
        }
    }
}
