/**
 * Copyright © 2014-2015 XebiaLabs B.V. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization.xstream;

import javax.ws.rs.ext.Provider;

import org.jboss.resteasy.spi.StringConverter;
import org.joda.time.LocalDate;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Provider
public class LocalDateStringConverter implements StringConverter<LocalDate> {

    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd");

    @Override
    public LocalDate fromString(String yyyyMMdd) {
        return LocalDate.parse(yyyyMMdd, DATE_FORMAT);
    }

    @Override
    public String toString(LocalDate value) {
        return DATE_FORMAT.print(value);
    }
}
