package com.xebialabs.xltype.serialization.xstream;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;

import java.util.Map;

import static com.xebialabs.xltype.serialization.xstream.Converters.writeNode;

public abstract class AbstractTaskWithBlockConverter implements Converter {

    @Override
    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        TaskWithBlock task = (TaskWithBlock) source;
        writer.addAttribute("id", task.getId());
        writer.addAttribute("failures", Integer.toString(task.getFailureCount()));
        writer.addAttribute("state", task.getState().name());
        writer.addAttribute("owner", task.getOwner());

        writeNode("description", task.getDescription(), writer);

        if (task.getStartDate() != null) {
            writeNode("startDate", new DateTimeAdapter().marshal(task.getStartDate()), writer);
        }
        if (task.getCompletionDate() != null) {
            writeNode("completionDate", new DateTimeAdapter().marshal(task.getCompletionDate()), writer);
        }
        if (task.getScheduledDate() != null) {
            writeNode("scheduledDate", new DateTimeAdapter().marshal(task.getScheduledDate()), writer);
        }

        writer.startNode("activeBlocks");
        if (task.getActiveBlocks() != null) {
            for (String current : task.getActiveBlocks()) {
                if (current != null) {
                    writeNode("active", current, writer);
                }
            }
        }
        writer.endNode();

        Map<String, String> metadata = task.getMetadata();
        writer.startNode("metadata");
        for (Map.Entry<String, String> e : metadata.entrySet()) {
            writeNode(e.getKey(), e.getValue(), writer);
        }
        writer.endNode();

        if (task.getBlock() != null) {
            writePhaseContainer(writer, context, task);
        }
    }

    protected void writePhaseContainer(HierarchicalStreamWriter writer, MarshallingContext context, TaskWithBlock task) {
        writer.startNode("block");
        Converters.writeBlockTree(task.getBlock(), writer, context, false);
        writer.endNode();
    }

    @Override
    public boolean canConvert(final Class type) {
        return TaskWithBlock.class.isAssignableFrom(type);

    }

}
