package com.xebialabs.xltype.serialization.jdom;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Deque;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public class JdomWriter {

    private Document document;
    private Deque<Element> elementStack = new ArrayDeque<Element>();

    public JdomWriter() {
        this.document = new Document();
    }

    public JdomWriter element(String name) {
        Element e = new Element(name);
        if (elementStack.isEmpty()) {
            document.addContent(e);
        } else {
            elementStack.peek().addContent(e);
        }
        elementStack.push(e);
        return this;
    }

    public JdomWriter endElement() {
        elementStack.pop();
        return this;
    }

    public JdomWriter attribute(String name, String value) {
        elementStack.peek().setAttribute(name, value);
        return this;
    }

    public JdomWriter value(String value) {
        elementStack.peek().setText(value);
        return this;
    }

    @Override
    public String toString() {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        StringWriter stringWriter = new StringWriter();
        try {
            outputter.output(document, stringWriter);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }
}
