package com.xebialabs.xltype.serialization.json;

import java.util.Map;

import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;

public class TaskWithBlockJsonConverter extends JsonConverter<TaskWithBlock> {
    private final DateTimeAdapter timeAdapter = new DateTimeAdapter();
    private final BlockStateJsonConverter blockConverter = new BlockStateJsonConverter();

    public JsonWriter writeJsonObject(TaskWithBlock taskWithBlock, JsonWriter writer) {

        writer.object();
        writer.key("id").value(taskWithBlock.getId());
        writer.key("failures").value(taskWithBlock.getFailureCount());
        writer.key("owner").value(taskWithBlock.getOwner());
        writer.key("state").value(taskWithBlock.getState());

        if (taskWithBlock.getDescription() != null) {
            writer.key("description").value(taskWithBlock.getDescription());
        }

        if (taskWithBlock.getCompletionDate() != null) {
            writer.key("completionDate").value(timeAdapter.marshal(taskWithBlock.getCompletionDate()));
        }

        if (taskWithBlock.getScheduledDate() != null) {
            writer.key("scheduledDate").value(timeAdapter.marshal(taskWithBlock.getScheduledDate()));
        }

        if (taskWithBlock.getActiveBlocks() != null && !taskWithBlock.getActiveBlocks().isEmpty()) {
            writer.array();
            for (String activeBlocks : taskWithBlock.getActiveBlocks()) {
                writer.value(activeBlocks);
            }
        }

        if (taskWithBlock.getMetadata() != null && !taskWithBlock.getMetadata().isEmpty()) {
            writer.key("metadata").object();
            for (Map.Entry<String, String> entry : taskWithBlock.getMetadata().entrySet()) {
                writer.key(entry.getKey()).value(entry.getValue());
            }
            writer.endObject();
        }

        if (taskWithBlock.getBlock() != null) {
            writeBlock(taskWithBlock.getBlock(), writer);
        }

        writer.endObject();

        return writer;
    }

    private void writeBlock(BlockState task, JsonWriter writer) {
        writer.key("block");
        blockConverter.writeJsonObject(task, writer);
    }
}
