/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.jdom;

import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.udm.CiAttributes;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiWriter;
import com.xebialabs.xltype.serialization.jdom.JdomWriter;
import com.xebialabs.xltype.serialization.xstream.DateTimeAdapter;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class CiJdomWriter
implements CiWriter {
    private final DateTimeAdapter dateTimeAdapter = new DateTimeAdapter();
    private final JdomWriter jdomWriter;
    private Deque<Boolean> suppressListStack = new ArrayDeque<Boolean>();

    public CiJdomWriter() {
        this(new JdomWriter());
    }

    public CiJdomWriter(JdomWriter jdomWriter) {
        this.jdomWriter = jdomWriter;
        this.suppressListStack.push(false);
    }

    @Override
    public void startList() {
        if (this.suppressListStack.peek().booleanValue()) {
            return;
        }
        this.jdomWriter.element("list");
    }

    @Override
    public void endList() {
        if (this.suppressListStack.peek().booleanValue()) {
            return;
        }
        this.jdomWriter.endElement();
    }

    @Override
    public void startCi(String type, String id) {
        this.jdomWriter.element(type).attribute("id", id);
    }

    @Override
    public void endCi() {
        this.jdomWriter.endElement();
    }

    @Override
    public void token(String token) {
        this.jdomWriter.attribute("token", token);
    }

    @Override
    public void ciAttributes(CiAttributes ciAttributes) {
        this.addStringAttribute("created-by", ciAttributes.getCreatedBy());
        this.addDateAttribute("created-at", ciAttributes.getCreatedAt());
        this.addStringAttribute("last-modified-by", ciAttributes.getLastModifiedBy());
        this.addDateAttribute("last-modified-at", ciAttributes.getLastModifiedAt());
    }

    private void addStringAttribute(String attrName, String attrValue) {
        if (attrValue != null) {
            this.jdomWriter.attribute(attrName, attrValue);
        }
    }

    private void addDateAttribute(String attrName, DateTime attrValue) {
        if (attrValue != null) {
            this.jdomWriter.attribute(attrName, this.dateTimeAdapter.marshal(attrValue));
        }
    }

    @Override
    public void startProperty(String name) {
        this.jdomWriter.element(name);
        this.suppressListStack.push(true);
    }

    @Override
    public void endProperty() {
        this.jdomWriter.endElement();
        this.suppressListStack.pop();
    }

    @Override
    public void valueAsString(Object value) {
        this.jdomWriter.value(value.toString());
    }

    @Override
    public void valuesAsStrings(Collection<?> values) {
        for (Object value : values) {
            this.jdomWriter.element("value").value(value.toString()).endElement();
        }
    }

    @Override
    public void mapAsStrings(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.jdomWriter.element("entry").attribute("key", entry.getKey().toString()).value(entry.getValue().toString()).endElement();
        }
    }

    @Override
    public void ciReference(String reference) {
        this.jdomWriter.attribute("ref", reference);
    }

    @Override
    public void ciReferences(Collection<String> references) {
        for (String reference : references) {
            this.jdomWriter.element("ci").attribute("ref", reference).endElement();
        }
    }

    @Override
    public void typedCiReference(ConfigurationItemId ci) {
        this.jdomWriter.element("ci");
        this.jdomWriter.attribute("ref", ci.getId());
        if (ci.getType() != null) {
            this.jdomWriter.attribute("type", ci.getType().toString());
        }
        this.jdomWriter.endElement();
    }

    @Override
    public void typedCiReferences(Collection<ConfigurationItemId> references) {
        this.jdomWriter.element("list");
        for (ConfigurationItemId reference : references) {
            this.typedCiReference(reference);
        }
        this.jdomWriter.endElement();
    }

    @Override
    public void validationMessages(List<ValidationMessage> validations) {
        this.jdomWriter.element("validation-messages");
        for (ValidationMessage validation : validations) {
            this.jdomWriter.element("validation-message");
            this.jdomWriter.attribute("ci", validation.getCiId());
            if (validation.getPropertyName() != null) {
                this.jdomWriter.attribute("property", validation.getPropertyName());
            }
            this.jdomWriter.value(validation.getMessage());
            this.jdomWriter.endElement();
        }
        this.jdomWriter.endElement();
    }

    public String toString() {
        return this.jdomWriter.toString();
    }
}

