/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.dto.Control;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.xltype.serialization.Checks;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class ControlJsonConverter {
    private final ConfigurationItemConverter ciConverter;

    public ControlJsonConverter(ConfigurationItemConverter converter) {
        this.ciConverter = converter;
    }

    public ConfigurationItemConverter getCiConverter() {
        return this.ciConverter;
    }

    public String toJson(Control control) {
        JsonWriter writer = new JsonWriter();
        CiJsonWriter ciWriter = new CiJsonWriter(writer);
        writer.object();
        writer.key("method").value(control.getControlName());
        writer.key("controllable");
        this.ciConverter.writeCi(control.getConfigurationItem(), ciWriter);
        writer.key("parameter");
        this.ciConverter.writeCi((ConfigurationItem)control.getParameters(), ciWriter);
        writer.endObject();
        return writer.toString();
    }

    public Control toControl(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            Checks.checkArgument(json.has("method"), "Missing 'method' property in JSON:\n%s", jsonString);
            Checks.checkArgument(json.has("controllable"), "Missing 'controllable' property in JSON:\n%s", jsonString);
            Checks.checkArgument(json.has("parameters"), "Missing 'parameters' property in JSON:\n%s", jsonString);
            String name = json.getString("method");
            ConfigurationItem ci = this.ciConverter.readCi(new CiJsonReader(json.getJSONObject("controllable")));
            Parameters parameters = (Parameters)this.ciConverter.readCi(new CiJsonReader(json.getJSONObject("parameters")));
            return new Control(ci, name, parameters);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }
}

