/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization.json;

import com.xebialabs.deployit.engine.api.dto.Inspection;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.json.CiJsonReader;
import com.xebialabs.xltype.serialization.json.CiJsonWriter;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class InspectionJsonConverter {
    private final ConfigurationItemConverter ciConverter;

    public InspectionJsonConverter(ConfigurationItemConverter converter) {
        this.ciConverter = converter;
    }

    public ConfigurationItemConverter getCiConverter() {
        return this.ciConverter;
    }

    public String toJson(Inspection inspection) {
        JsonWriter writer = new JsonWriter();
        CiJsonWriter ciWriter = new CiJsonWriter(writer);
        writer.object();
        writer.key("inspectable");
        this.ciConverter.writeCi(inspection.getConfigurationItem(), ciWriter);
        writer.endObject();
        return writer.toString();
    }

    public Inspection toInspection(String jsonString) {
        try {
            JSONObject json = new JSONObject(jsonString);
            if (!json.has("inspectable")) {
                throw new IllegalArgumentException(String.format("Missing 'inspectable' property in JSON:\n%s", jsonString));
            }
            ConfigurationItem ci = this.ciConverter.readCi(new CiJsonReader(json.getJSONObject("inspectable")));
            return new Inspection(ci);
        }
        catch (JSONException e) {
            throw new IllegalArgumentException("Can't parse JSON:\n" + jsonString, e);
        }
    }
}

