/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization

import com.thoughtworks.xstream.XStream
import com.xebialabs.deployit.engine.api.execution.IArchivedTask
import com.xebialabs.xltype.serialization.xstream.{ArchivedTaskWriter, StepStateWriter, XStreamReaderWriter}
import org.springframework.stereotype.Component

@Component
class TaskArchiveWriter extends XStream(XStreamReaderWriter.HIERARCHICAL_STREAM_DRIVER) {
  this.registerConverter(new ArchivedTaskWriter())
  this.registerConverter(new StepStateWriter())
  this.aliasType("task", classOf[IArchivedTask])
}
