/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.xltype.serialization;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;

@SuppressWarnings("serial")
public class CiWithAll extends BaseConfigurationItem {

    public static enum FooBar { Foo, Bar;}

    @Property(required = false)
    private String string;

    @Property(required = false)
    private int integer;

    @Property(required = false)
    private boolean bool;

    @Property(required = false)
    private FooBar enumeration;

    @Property(required = false)
    private Set<String> stringSet;

    @Property(required = false)
    private Map<String, String> map;

    @Property(required = false)
    private CiWithAll ci;

    @Property(required = false)
    private Set<CiWithAll> ciSet;

    @Property(required = false)
    private List<String> stringList;

    @Property(required = false)
    private List<CiWithAll> ciList;

    @Property(required = false)
    private SonOfCi singleChild;

    @Property(required = false, nested = true)
    private NestedCi nestedChild;

    @Property(required = false, asContainment = true)
    private Set<CiWithAll> childSet;

    @Property(required = false, asContainment = true)
    private List<CiWithAll> childList;

    @Property(required = false)
    private Date date;

    public String getString() {
        return string;
    }

    public int getInteger() {
        return integer;
    }

    public boolean isBool() {
        return bool;
    }

    public FooBar getEnumeration() {
        return enumeration;
    }

    public Set<String> getStringSet() {
        return stringSet;
    }

    public Map<String, String> getMap() {
        return map;
    }

    public CiWithAll getCi() {
        return ci;
    }

    public Set<CiWithAll> getCiSet() {
        return ciSet;
    }

    public List<CiWithAll> getCiList(){
        return ciList;
    }

    public List<String> getStringList(){
        return stringList;
    }

    public Set<CiWithAll> getChildSet() {
        return childSet;
    }

    public List<CiWithAll> getChildList() {
        return childList;
    }

    public Date getDate() {
        return date;
    }

    public SonOfCi getSingleChild() {
        return singleChild;
    }

    public NestedCi getNestedChild() {
        return nestedChild;
    }

    public static CiWithAll newCi(String id) {
        return newCi(id, CiWithAll.class);
    }

    public static <T extends ConfigurationItem> T newCi(String id, Class<T> ciType) {
        return Type.valueOf(ciType).getDescriptor().newInstance(id);
    }
}
