/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xltype.serialization;

import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.engine.api.dto.ValidatedConfigurationItem;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;
import com.xebialabs.xltype.serialization.CiListReader;
import com.xebialabs.xltype.serialization.CiReader;
import com.xebialabs.xltype.serialization.CiReference;
import com.xebialabs.xltype.serialization.CiWithAll;
import com.xebialabs.xltype.serialization.ConfigurationItemConverter;
import com.xebialabs.xltype.serialization.SonOfCi;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class CiReaderTestBase<Reader extends CiReader, ListReader extends CiListReader> {
    private String format;
    private ConfigurationItemConverter converter;
    private Function<URL, Reader> constructCiReader;
    private Function<URL, ListReader> constructCiListReader;

    public CiReaderTestBase(String format, Function<URL, Reader> constructCiReader, Function<URL, ListReader> constructCiListReader) {
        this.format = format;
        this.constructCiReader = constructCiReader;
        this.constructCiListReader = constructCiListReader;
    }

    @BeforeClass
    public static void boot() {
        LocalBooter.bootWithoutGlobalContext();
    }

    @BeforeMethod
    public void createConverter() {
        this.converter = new ConfigurationItemConverter();
    }

    private URL getTestingResource(String resource) {
        String classpathResource = String.format("%s/%s.%s", this.format, resource, this.format);
        return Thread.currentThread().getContextClassLoader().getResource(classpathResource);
    }

    private CiReader createReader(String file) {
        return (CiReader)this.constructCiReader.apply(this.getTestingResource(file));
    }

    private CiListReader createListReader(String file) {
        return (CiListReader)this.constructCiListReader.apply(this.getTestingResource(file));
    }

    private static void assertReference(List<CiReference> references, String ci, String property, String ref) {
        for (CiReference reference : references) {
            if (!reference.getCi().getId().equals(ci) || !reference.getProperty().getName().equals(property) || !reference.getIds().contains(ref)) continue;
            return;
        }
        MatcherAssert.assertThat((String)String.format("Reference '%s=>%s = [%s]' not found in %s", ci, property, ref, references), (boolean)false);
    }

    @Test
    public void readCi() {
        CiReader reader = this.createReader("ci");
        ConfigurationItem ci = this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)ci, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ci.getType(), (Matcher)Matchers.is((Object)Type.valueOf(CiWithAll.class)));
        MatcherAssert.assertThat((Object)ci.getId(), (Matcher)Matchers.is((Object)"01"));
        MatcherAssert.assertThat((Object)ci.getProperty("integer"), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)ci.getProperty("bool"), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)((BaseConfigurationItem)ci).get$token(), (Matcher)Matchers.is((Object)"123"));
    }

    @Test
    public void readCiReference() {
        CiReader reader = this.createReader("ci-with-reference");
        ConfigurationItem ci = this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)ci, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.converter.getReferences(), (Matcher)Matchers.hasSize((int)1));
        CiReaderTestBase.assertReference(this.converter.getReferences(), "01", "ci", "02");
    }

    @Test
    public void readSetAndListOfCis() {
        CiReader reader = this.createReader("ci-with-references");
        ConfigurationItem ci = this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)ci, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.converter.getReferences(), (Matcher)Matchers.hasSize((int)2));
        CiReaderTestBase.assertReference(this.converter.getReferences(), "01", "ciSet", "02");
        CiReaderTestBase.assertReference(this.converter.getReferences(), "01", "ciList", "03");
    }

    @Test
    public void readSetAndListOfStrings() {
        CiReader reader = this.createReader("ci-with-strings");
        ConfigurationItem ci = this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)ci.getProperty("stringSet"), (Matcher)Matchers.equalTo(new HashSet<String>(Arrays.asList("a", "b", "c"))));
        MatcherAssert.assertThat((Object)ci.getProperty("stringList"), (Matcher)Matchers.equalTo(Arrays.asList("1", "2", "3")));
    }

    @Test
    public void readMapOfStrings() {
        CiReader reader = this.createReader("ci-with-string-map");
        ConfigurationItem ci = this.converter.readCi(reader);
        HashMap<String, String> expected = new HashMap<String, String>();
        expected.put("1", "a");
        expected.put("2", "b");
        MatcherAssert.assertThat((Object)ci.getProperty("map"), (Matcher)Matchers.equalTo(expected));
    }

    @Test
    public void readDate() {
        CiReader reader = this.createReader("ci-with-date");
        ConfigurationItem ci = this.converter.readCi(reader);
        Calendar calendar = Calendar.getInstance();
        Date date = (Date)ci.getProperty("date");
        calendar.setTime(date);
        MatcherAssert.assertThat((Object)calendar.get(1), (Matcher)Matchers.is((Object)2000));
        MatcherAssert.assertThat((Object)calendar.get(2), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((Object)calendar.get(5), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void readEmptyDate() {
        CiReader reader = this.createReader("ci-with-empty-date");
        ConfigurationItem ci = this.converter.readCi(reader);
        Date date = (Date)ci.getProperty("date");
        MatcherAssert.assertThat((Object)date, (Matcher)Matchers.nullValue());
    }

    @Test
    public void readNoValidationMessages() {
        CiReader reader = this.createReader("ci-with-validation-messages");
        this.converter.setReadValidationMessages(false);
        ConfigurationItem ci = this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)ci, (Matcher)Matchers.not((Matcher)Matchers.instanceOf(ValidatedConfigurationItem.class)));
    }

    @Test
    public void readValidationMessages() {
        CiReader reader = this.createReader("ci-with-validation-messages");
        this.converter.setReadValidationMessages(true);
        ConfigurationItem ci = this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)ci, (Matcher)Matchers.instanceOf(ValidatedConfigurationItem.class));
        ValidatedConfigurationItem validatedCi = (ValidatedConfigurationItem)ci;
        MatcherAssert.assertThat((Object)validatedCi.getValidations(), (Matcher)Matchers.hasSize((int)2));
        ValidationMessage message = (ValidationMessage)validatedCi.getValidations().get(0);
        MatcherAssert.assertThat((Object)message.getCiId(), (Matcher)Matchers.is((Object)"01"));
        MatcherAssert.assertThat((Object)message.getPropertyName(), (Matcher)Matchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)message.getMessage(), (Matcher)Matchers.is((Object)"String should not be empty"));
        MatcherAssert.assertThat((Object)message.getLevel(), (Matcher)Matchers.is((Object)ValidationMessage.Level.ERROR));
        message = (ValidationMessage)validatedCi.getValidations().get(1);
        MatcherAssert.assertThat((Object)message.getCiId(), (Matcher)Matchers.is((Object)"01"));
        MatcherAssert.assertThat((Object)message.getPropertyName(), (Matcher)Matchers.is((Object)"string"));
        MatcherAssert.assertThat((Object)message.getMessage(), (Matcher)Matchers.is((Object)"This is a warning"));
        MatcherAssert.assertThat((Object)message.getLevel(), (Matcher)Matchers.is((Object)ValidationMessage.Level.WARNING));
    }

    @Test
    public void readCis() {
        CiListReader reader = this.createListReader("list-of-cis");
        List configurationItems = this.converter.readCis(reader);
        MatcherAssert.assertThat((Object)configurationItems.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ConfigurationItem)configurationItems.get(0)).getId(), (Matcher)Matchers.is((Object)"01"));
        MatcherAssert.assertThat((Object)((ConfigurationItem)configurationItems.get(0)).getType().toString(), (Matcher)Matchers.is((Object)"test.CiWithAll"));
        MatcherAssert.assertThat((Object)((ConfigurationItem)configurationItems.get(1)).getProperty("bool"), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ConfigurationItem)configurationItems.get(1)).getProperty("integer"), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)this.converter.getReferences(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((CiReference)this.converter.getReferences().get(0)).getIds(), (Matcher)Matchers.hasSize((int)1));
        CiReaderTestBase.assertReference(this.converter.getReferences(), "01", "ci", "02");
        MatcherAssert.assertThat((Object)((CiReference)this.converter.getReferences().get(1)).getIds(), (Matcher)Matchers.hasSize((int)2));
        CiReaderTestBase.assertReference(this.converter.getReferences(), "02", "ciSet", "01");
        CiReaderTestBase.assertReference(this.converter.getReferences(), "02", "ciSet", "03");
    }

    @Test
    public void readNestedCi() {
        CiReader reader = this.createReader("ci-with-nested-ci");
        CiWithAll ci = (CiWithAll)this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)((Object)ci), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ci.getId(), (Matcher)Matchers.is((Object)"01"));
        SonOfCi child = ci.getSingleChild();
        Assert.assertNotNull((Object)((Object)child));
        MatcherAssert.assertThat((Object)child.getId(), (Matcher)Matchers.is((Object)"02"));
        MatcherAssert.assertThat((Object)child.getProperty("string"), (Matcher)Matchers.is((Object)"nested"));
    }

    @Test
    public void readChildList() {
        CiReader reader = this.createReader("ci-with-child-list");
        CiWithAll ci = (CiWithAll)this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)((Object)ci), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ci.getId(), (Matcher)Matchers.is((Object)"01"));
        List<CiWithAll> nestedCIs = ci.getChildList();
        MatcherAssert.assertThat(nestedCIs, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)nestedCIs.get(0).getId(), (Matcher)Matchers.is((Object)"02"));
        MatcherAssert.assertThat((Object)nestedCIs.get(0).getProperty("string"), (Matcher)Matchers.is((Object)"nested"));
        MatcherAssert.assertThat((Object)nestedCIs.get(1).getId(), (Matcher)Matchers.is((Object)"03"));
        MatcherAssert.assertThat((Object)nestedCIs.get(1).getProperty("string"), (Matcher)Matchers.is((Object)"sibling"));
    }

    @Test
    public void readChildSet() {
        CiReader reader = this.createReader("ci-with-child-set");
        CiWithAll ci = (CiWithAll)this.converter.readCi(reader);
        MatcherAssert.assertThat((Object)((Object)ci), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)ci.getId(), (Matcher)Matchers.is((Object)"01"));
        Set<CiWithAll> nestedCIs = ci.getChildSet();
        MatcherAssert.assertThat(nestedCIs, (Matcher)Matchers.hasSize((int)2));
    }

    @Test
    public void readListOfNestedCisWithReferences() {
        CiListReader reader = this.createListReader("list-of-nested-cis-with-references");
        List cis = this.converter.readCis(reader);
        MatcherAssert.assertThat((Object)cis.size(), (Matcher)Matchers.is((Object)2));
        MatcherAssert.assertThat((Object)((ConfigurationItem)cis.get(0)).getId(), (Matcher)Matchers.is((Object)"01"));
        MatcherAssert.assertThat((Object)((ConfigurationItem)cis.get(1)).getId(), (Matcher)Matchers.is((Object)"03"));
        CiWithAll ci2 = ((CiWithAll)((Object)cis.get(0))).getCi();
        MatcherAssert.assertThat((Object)ci2.getId(), (Matcher)Matchers.is((Object)"02"));
        MatcherAssert.assertThat((Object)this.converter.getReferences(), (Matcher)Matchers.hasSize((int)1));
        CiReaderTestBase.assertReference(this.converter.getReferences(), "02", "ci", "03");
    }
}

