/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.documentation;

import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.documentation.ContextProperties;
import com.xebialabs.deployit.documentation.MarkdownHtmlGenerator;
import com.xebialabs.deployit.documentation.StepReferenceFreemarkerTemplate;
import com.xebialabs.deployit.plugin.api.rules.StepMetadata;
import com.xebialabs.deployit.plugin.api.rules.StepParameter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import nl.javadude.scannit.Configuration;
import nl.javadude.scannit.Scannit;
import nl.javadude.scannit.scanner.AbstractScanner;
import nl.javadude.scannit.scanner.TypeAnnotationScanner;

public class StepReferenceGenerator {
    private final Scannit scannit;
    private final StepReferenceFreemarkerTemplate template;
    private final List<File> markdownSources;
    private final ContextProperties contextProperties;

    public StepReferenceGenerator(String packageName, Writer writer, List<File> markdownSources, ContextProperties contextProperties) {
        this.markdownSources = markdownSources;
        this.contextProperties = contextProperties;
        try {
            Configuration configuration = Configuration.config().scan(packageName).with(new AbstractScanner[]{new TypeAnnotationScanner()});
            this.scannit = new Scannit(configuration);
            this.template = new StepReferenceFreemarkerTemplate(writer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void generateStepReference() {
        try {
            List<Step> steps = this.findSteps();
            if (!steps.isEmpty()) {
                HashMap<String, Object> templateData = new HashMap<String, Object>();
                templateData.put("steps", steps);
                this.template.writeGeneratedPage(templateData);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<Step> findSteps() {
        return Lists.newArrayList((Iterable)Iterables.transform((Iterable)this.scannit.getTypesAnnotatedWith(StepMetadata.class), (Function)new ClassToStep()));
    }

    public static class Parameter {
        String name;
        String label;
        String description;
        Boolean required;
        Boolean calculated;
        String type;

        private Parameter(String name, String type, String label, String description, Boolean required, Boolean calculated) {
            this.name = name;
            this.label = label;
            this.description = description;
            this.type = type;
            this.required = required;
            this.calculated = calculated;
        }

        public String getName() {
            return this.name;
        }

        public String getLabel() {
            return this.label;
        }

        public String getDescription() {
            return this.description;
        }

        public Boolean getRequired() {
            return this.required;
        }

        public String getType() {
            return this.type;
        }

        public Boolean getCalculated() {
            return this.calculated;
        }
    }

    public static class Step {
        private String name;
        private String htmlDescription;
        private List<Parameter> parameters;

        private Step(String name, String htmlDescription, List<Parameter> parameters) {
            this.name = name;
            this.parameters = parameters;
            this.htmlDescription = htmlDescription;
        }

        public String getName() {
            return this.name;
        }

        public List<Parameter> getParameters() {
            return this.parameters;
        }

        public String getHtmlDescription() {
            return this.htmlDescription;
        }
    }

    private static class FiledToParameter
    implements Function<Field, Parameter> {
        private FiledToParameter() {
        }

        public Parameter apply(Field field) {
            StepParameter stepParameter = field.getAnnotation(StepParameter.class);
            return new Parameter(this.getName(field, stepParameter), field.getType().getSimpleName(), stepParameter.label(), stepParameter.description(), stepParameter.required(), stepParameter.calculated());
        }

        private String getName(Field field, StepParameter stepParameter) {
            String parameterName = stepParameter.name().isEmpty() ? field.getName() : stepParameter.name();
            return CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, parameterName);
        }
    }

    private static class StepFilenameFilter
    implements Predicate<File> {
        private String stepName;

        private StepFilenameFilter(String stepName) {
            this.stepName = stepName;
        }

        public boolean apply(File file) {
            return "step-".concat(this.stepName.concat(".markdown")).equals(file.getName());
        }
    }

    private class ClassToStep
    implements Function<Class<?>, Step> {
        private ClassToStep() {
        }

        public Step apply(Class<?> stepClass) {
            ArrayList parameters = Lists.newArrayList((Iterable)Iterables.transform(this.getAllFields(stepClass, StepParameter.class), (Function)new FiledToParameter()));
            String name = stepClass.getAnnotation(StepMetadata.class).name();
            return new Step(name, this.generateStepDescription(name), parameters);
        }

        private List<Field> getAllFields(Class<?> aClass, Class<? extends Annotation> annotation) {
            ArrayList<Field> result = new ArrayList<Field>();
            for (Field field : aClass.getDeclaredFields()) {
                if (field.getAnnotation(annotation) == null) continue;
                result.add(field);
            }
            Class<?> superclass = aClass.getSuperclass();
            if (superclass != null) {
                result.addAll(this.getAllFields(superclass, annotation));
            }
            return result;
        }

        private String generateStepDescription(String stepName) {
            StringWriter writer = new StringWriter();
            ArrayList markdowns = Lists.newArrayList((Iterable)Iterables.filter((Iterable)StepReferenceGenerator.this.markdownSources, (Predicate)new StepFilenameFilter(stepName)));
            Preconditions.checkArgument((!markdowns.isEmpty() ? 1 : 0) != 0, (String)"Please provide markdown file step-%s.markdown", (Object[])new Object[]{stepName});
            for (File markdown : markdowns) {
                new MarkdownHtmlGenerator(markdown, StepReferenceGenerator.this.contextProperties).generate(writer);
            }
            return writer.getBuffer().toString();
        }
    }
}

