/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

import java.util.List;

public class CisDeletedEvent extends CiBaseEvent {
    private String[] ids;

    public CisDeletedEvent(List<ConfigurationItem> cis) {
        super("repository", String.format("Deleted CIs %s", format(cis)), cis);

        ids = new String[cis.size()];
        for (int i = 0; i < cis.size(); i++) {
            ids[i] = cis.get(i).getId();
        }
    }

    public String[] getIds() {
        return ids;
    }
}
