package com.xebialabs.deployit.engine.spi.event;


public class UserCreatedEvent extends AuditableDeployitEvent {

    private final String username;
    
    public UserCreatedEvent(String username) {
        super("security", String.format("Created user %s", format(username)));
        this.username = username;
    }

    public String getUsername() {
        return username;
    }
}
