package com.xebialabs.deployit.engine.spi.event;


public class PermissionGrantedEvent extends AuditableDeployitEvent {

    private final String id;
    private final String roleName;
    private final String permission;

    public PermissionGrantedEvent(String id, String roleName, String permission) {
        super("security", String.format("Granted permission %s to role %s on CI %s", format(permission), 
            format(roleName), format(id)));
        this.id = id;
        this.roleName = roleName;
        this.permission = permission;
    }

    public String getId() {
        return id;
    }

    public String getRoleName() {
        return roleName;
    }

    public String getPermission() {
        return permission;
    }
    
}
