package com.xebialabs.deployit.engine.spi.event;

import java.util.HashMap;
import java.util.Map;



/**
 * Event class representing an event that occurred in the system.
 */
public class AuditableDeployitEvent {
    public String component;
    public String message;
    public String username = "unknown";

    /**
     * Optional field representing the information in the event in a structured, field-by-field
     * manner. Can be used to output the event in a structured way, such as a CSV file.
     */
    private Map<String, String> dataFields = new HashMap<String, String>();
    
    public AuditableDeployitEvent(String component, String message) {
        this.component = component;
        this.message = message;
    }

    // Username can be set after the event is created. This to centralize access to the security system.
    public void setUsername(String username) {
        this.username = username;
    }

    public Map<String, String> getDataFields() {
        return dataFields;
    }

    protected static String format(String... strings) {
        StringBuilder sb = new StringBuilder();
    
        for (String string: strings) {
            sb.append(format(string));
            sb.append(" ");
        }
    
        return sb.toString();
    }

    protected static String format(String string) {
        return "[" + string + "]";
    }
}
