package com.xebialabs.deployit.engine.spi.orchestration;

import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;

import java.util.List;

import static com.google.common.collect.Lists.newArrayList;
import static java.util.Collections.unmodifiableList;

/**
 * The lowest type of sub-plan, this plan contains {@link com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep}s which can be executed and {@link com.xebialabs.deployit.plugin.api.deployment.specification.Delta} objects
 * for which this InterleavedPlan has been built.
 *
 * The {@link com.xebialabs.deployit.plugin.api.deployment.execution.DeploymentStep}s in the InterleavedPlan are sorted by the {@link com.xebialabs.deployit.engine.spi.planning.StepComparator}
 */
public final class InterleavedOrchestration implements Orchestration {
    private List<Delta> deltas;

    InterleavedOrchestration(List<Delta> deltas) {
        this.deltas = unmodifiableList(deltas);
    }

    InterleavedOrchestration(Delta... deltas) {
        this(newArrayList(deltas));
    }

    /**
     * Gets the {@link com.xebialabs.deployit.plugin.api.deployment.specification.Delta}s for which this InterleavedPlan has been compiled
     * @return the Delta's
     */
    public List<Delta> getDeltas() {
        return deltas;
    }

    @Override
    public String getType() {
        return InterleavedOrchestration.class.getName();
    }
}
