package com.xebialabs.deployit.engine.spi.event;


public class PrincipalRoleAssignmentDeletedEvent extends AuditableDeployitEvent {

    private final String roleName;
    private final String principal;
    
    public PrincipalRoleAssignmentDeletedEvent(String principal, String roleName) {
        super("security", String.format("Unassigned principal %s from role %s", format(principal), format(roleName)));
        this.roleName = roleName;
        this.principal = principal;
    }

    public String getRoleName() {
        return roleName;
    }

    public String getPrincipal() {
        return principal;
    }
    
}
