package com.xebialabs.deployit.engine.spi.event;


public class PrincipalRoleAssignmentCreatedEvent extends AuditableDeployitEvent {

    private final String roleName;
    private final String principal;
    
    public PrincipalRoleAssignmentCreatedEvent(String principal, String roleName) {
        super("security", String.format("Assigned principal %s to role %s", format(principal), format(roleName)));
        this.roleName = roleName;
        this.principal = principal;
    }

    public String getRoleName() {
        return roleName;
    }

    public String getPrincipal() {
        return principal;
    }
    
}
