package com.xebialabs.deployit.engine.spi.event;

import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;

public class CiMovedEvent extends CiBaseEvent {

    private ConfigurationItem entity;
    private String newId;
    
    public CiMovedEvent(ConfigurationItem entity, String newId) {
        super("repository", String.format("Moved CI %s to %s", format(entity), format(newId)));
        this.entity = entity;
        this.newId = newId;
    }

    public ConfigurationItem getEntity() {
        return entity;
    }

    public String getNewId() {
        return newId;
    }

}
