/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.execution;

import com.xebialabs.deployit.engine.api.execution.BlockExecutionState;
import com.xebialabs.deployit.engine.api.execution.BlockState;
import com.xebialabs.deployit.engine.api.execution.TaskWithBlock;

public interface BlockExecutionStateEvent {
    /**
     * Returns the previous state of the block.
     */
    BlockExecutionState previousState();

    /**
     * Returns the current state of the block.
     */
    BlockExecutionState currentState();

    /**
     * Return the detailed block information object.
     */
    BlockState block();

    /**
     * Return the detailed task information object.
     */
    TaskWithBlock task();
}
