/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.execution;

import com.xebialabs.deployit.engine.api.execution.StepExecutionState;
import com.xebialabs.deployit.engine.api.execution.TaskExecutionState;

@SuppressWarnings("deprecation")
public final class Transitions {

    private Transitions() {}

    public static boolean checkTransition(StepExecutionStateEvent e, StepExecutionState previous, StepExecutionState current) {
        return e.previousState() == previous && e.currentState() == current;
    }

    public static boolean checkTransition(TaskExecutionStateEvent e, TaskExecutionState previous, TaskExecutionState current) {
        return e.previousState() == previous && e.currentState() == current;
    }

}
