/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.server.api.util;

import com.xebialabs.deployit.plugin.api.udm.*;

public class IdGenerator {

    public static String generateId(String container, String contained) {
        return container + "/" + lastPartOfId(contained);

    }

    private static String lastPartOfId(String id) {
        if (id == null) {
            return null;
        }

        String[] split = id.split("/");
        return split[split.length - 1];
    }

    public static String generateId(ConfigurationItem container, ConfigurationItem contained) {
        return generateId(container.getId(), contained.getId());
    }

    public static String generateId(Metadata.ConfigurationItemRoot root, String id) {
        return generateId(root.getRootNodeName(), id);
    }

    public static String generateId(ConfigurationItem parent, String id) {
        return generateId(parent.getId(), id);
    }

    @SuppressWarnings("rawtypes")
    public static void generateId(Deployed deployed) {
        deployed.setId(generateId(deployed.getContainer(), deployed.getDeployable()));
    }

    public static void generateId(DeployedApplication deployedApplication) {
        Version version = deployedApplication.getVersion();

        deployedApplication.setId(generateId(deployedApplication.getEnvironment().getId(), version.getApplication().getId()));
    }
}
