/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;


public class PackageImportedEvent extends AuditableDeployitEvent {

    private final String id;

    public PackageImportedEvent(String id) {
        super("repository", String.format("Imported deployment package %s", format(id)));
        this.id = id;
    }

    public String getId() {
        return id;
    }
}
