/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;


public class TaskAssignedEvent extends TaskBaseEvent {

    private final String owner;
    
    public TaskAssignedEvent(String taskId, String owner) {
        super(taskId, String.format("Task %s assigned to %s", format(taskId), format(owner)));
        this.owner = owner;
    }

    public String getOwner() {
        return owner;
    }
    
}
