/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.command;

import java.util.List;

import com.xebialabs.deployit.engine.spi.command.util.Update;
import com.xebialabs.xlplatform.coc.dto.SCMTraceabilityData;

public class UpdateCisCommand extends RepositoryBaseCommand {
    private final List<Update> updates;
    private final SCMTraceabilityData scmTraceabilityData;

    public UpdateCisCommand(final List<Update> updates) {
        this.updates = updates;
        this.scmTraceabilityData = null;
    }

    public UpdateCisCommand(List<Update> updates, SCMTraceabilityData scmTraceabilityData) {
        this.updates = updates;
        this.scmTraceabilityData = scmTraceabilityData;
    }

    public List<Update> getUpdates() {
        return updates;
    }

    public SCMTraceabilityData getSCMTraceabilityData() {
        return scmTraceabilityData;
    }
}
