/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.server.api.importer;


/**
 */
public class PackageInfo {
    ImportSource source;

    String applicationName;

    String directories;

    String applicationVersion;

    String applicationRoot;

    public PackageInfo(ImportSource source) {
        this.source = source;
    }

    public ImportSource getSource() {
        return source;
    }

    public String getApplicationName() {
        return applicationName;
    }

    public String getDirectories() {
        return directories;
    }

    public String getApplicationId() {
        return getDistributionId(applicationRoot);
    }

    public String getApplicationRoot() { return applicationRoot; }

    private String getDistributionId(String rootName) {
        StringBuilder sb = new StringBuilder(rootName).append("/");
        if (directories != null && !directories.trim().isEmpty()) {
            sb.append(directories).append("/");
        }
        sb.append(applicationName);
        return sb.toString();
    }

    public String getApplicationVersion() {
        return applicationVersion;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setDirectories(String directories) {
        String dir = directories;
        if (dir.startsWith("/")) {
            dir = dir.substring(1);
        }
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        this.directories = dir;
    }

    public void setApplicationVersion(String applicationVersion) {
        this.applicationVersion = applicationVersion;
    }

    public void setApplicationRoot(String applicationRoot) {
        this.applicationRoot = applicationRoot;
    }
}
