/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;


public class PermissionRevokedEvent extends AuditableDeployitEvent {

    private final String id;
    private final String roleName;
    private final String permission;

    public PermissionRevokedEvent(String id, String roleName, String permission) {
        super("security", String.format("Revoked permission %s to role %s on CI %s", format(permission), 
            format(roleName), format(id)));
        this.id = id;
        this.roleName = roleName;
        this.permission = permission;
    }

    public String getId() {
        return id;
    }

    public String getRoleName() {
        return roleName;
    }

    public String getPermission() {
        return permission;
    }
    
}
