/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.server.api.upgrade;

/**
 * Interface for classes which initialize an empty XL repository for a product or a plugin.
 *
 * Initializations are ran in alphabetical order per component.
 */
public interface RepositoryInitialization {

    /**
     * Runs initialization logic for a component denoted by {@link #getComponent()} method.
     * Typically initializations create additional nodes in repository, setup default configuration CIs etc.
     */
    void doInitialize();

    /**
     * Defines the component to which this initialization belongs.
     *
     * @return the name of the component.
     */
    String getComponent();

    /**
     * Defines priority in which initialization will be executed.
     * Lower priority initializers will be executed first.
     * @return priority of the component.
     */
    default Integer getPriority() {
        return 0;
    };
}
