/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.server.api.importer;

import com.xebialabs.deployit.plugin.api.udm.Application;
import com.xebialabs.deployit.plugin.api.udm.Deployable;
import com.xebialabs.deployit.plugin.api.udm.DeploymentPackage;
import com.xebialabs.deployit.plugin.api.udm.Version;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public final class ImportedPackage {

    private Application application;

    private Version version;

    private final PackageInfo packageInfo;

    public ImportedPackage(PackageInfo packageInfo, Application application, Version version) {
        this.packageInfo = packageInfo;
        this.application = application;
        this.version = version;
    }

    public PackageInfo getPackageInfo() {
        return packageInfo;
    }

    public Application getApplication() {
        return application;
    }

    public Version getVersion() {
        return version;
    }

    public List<Deployable> getDeployables() {
        return new ArrayList<>(version.getDeployables());
    }

}
