/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.orchestration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * A CompositePlan holds other sub-plans which are either parallellized (see: {@link ParallelOrchestration}) or serialized (see: {@link SerialOrchestration}).
 */
public abstract class CompositeOrchestration implements Orchestration {
    protected List<Orchestration> plans = new ArrayList<>();
    private String description = "";

    protected CompositeOrchestration(String description, Orchestration... plans) {
        this(description, Arrays.asList(plans));
    }

    protected CompositeOrchestration(String description, List<Orchestration> plans) {
        this.plans.addAll(plans);
        this.description = description;
    }

    /**
     * Gets the full list of plans.
     * @return the full list of plans.
     */
    public List<Orchestration> getPlans() {
        return plans;
    }

    @Override
    public String getType() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }
}
