/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.engine.spi.event;


public class RoleCreatedEvent extends AuditableDeployitEvent {

    private final String roleName;
    
    public RoleCreatedEvent(String roleName) {
        super("security", String.format("Created role %s", format(roleName)));
        this.roleName = roleName;
    }

    public String getRoleName() {
        return roleName;
    }
}
