/**
 * Copyright 2014-2019 XebiaLabs Inc. and its affiliates. Use is subject to terms of the enclosed Legal Notice.
 */
package com.xebialabs.deployit.server.api.upgrade;

import com.xebialabs.deployit.server.api.repository.RawRepository;

@ApplicableRepoTypes(RepoType.JCR)
public abstract class JcrUpgrade extends Upgrade {

    private RawRepository repository;

    public void setRepository(RawRepository repository) {
        this.repository = repository;
    }

    @Override
    public boolean doUpgrade() throws UpgradeException {
        return doUpgrade(repository);
    }

    public abstract boolean doUpgrade(RawRepository repository) throws UpgradeException;

}
