package com.xebialabs.deployit.engine.api.dto;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

import static com.google.common.collect.Lists.newArrayList;

@XmlRootElement(name = "server-info")
public class ServerInfo extends AbstractDto {

    private String version;

    private List<ServerPluginInfo> pluginsInfo = newArrayList();

    private List<String> classpathEntries = newArrayList();

    @XmlElementWrapper(name = "plugins")
    @XmlElement(name = "plugin-info")
    public List<ServerPluginInfo> getPluginsInfo() {
        return pluginsInfo;
    }

    public void setPluginsInfo(List<ServerPluginInfo> pluginsInfo) {
        this.pluginsInfo = pluginsInfo;
    }

    @XmlElement(name = "version")
    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @XmlElementWrapper(name = "classpath")
    @XmlElement(name = "classpath-entry")
    public List<String> getClasspathEntries() {
        return classpathEntries;
    }

    public void setClasspathEntries(List<String> classpathEntries) {
        this.classpathEntries = classpathEntries;
    }



}
