package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.validation.ValidationMessage;

import java.util.List;
import java.util.Map;

import com.google.common.base.Joiner;

import static com.google.common.collect.Lists.newArrayList;

@SuppressWarnings("serial")
@Metadata(virtual = true)
public class ValidatedConfigurationItem implements ConfigurationItem {

    private ConfigurationItem wrapped;

    private List<ValidationMessage> validations = newArrayList();

    public ValidatedConfigurationItem(ConfigurationItem wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public String getId() {
        return wrapped.getId();
    }

    @Override
    public void setId(String id) {
        wrapped.setId(id);
    }

    @Override
    public String getName() {
        return wrapped.getName();
    }

    @Override
    public Type getType() {
        return wrapped.getType();
    }

    @Override
    public Map<String, Object> getSyntheticProperties() {
        return wrapped.getSyntheticProperties();
    }

    @Override
    public <T> T getSyntheticProperty(String key) {
        return wrapped.<T>getSyntheticProperty(key);
    }

    @Override
    public <T> void putSyntheticProperty(String key, T value) {
        wrapped.putSyntheticProperty(key, value);
    }

    @Override
    public <T> T getProperty(String key) {
        return wrapped.<T>getProperty(key);
    }

    @Override
    public boolean hasProperty(String key) {
        return wrapped.hasProperty(key);
    }

    @Override
    public <T> void setProperty(String key, T value) {
        wrapped.setProperty(key, value);
    }

    public List<ValidationMessage> getValidations() {
        return validations;
    }

    public void setValidations(List<ValidationMessage> validations) {
        this.validations = validations;
    }

    public ConfigurationItem getWrapped() {
        return wrapped;
    }

    @Override
    public String toString() {
        StringBuilder msg = new StringBuilder(String.format("CI [%s]: %d validation messages", wrapped.getId(), validations.size()));

        if (validations.isEmpty()) {
            return msg.toString();
        }

        return msg.append(": ").append(Joiner.on(", ").join(validations)).toString();
    }
}
