package com.xebialabs.deployit.engine.api;

import javax.ws.rs.*;
import javax.ws.rs.core.MediaType;

import com.xebialabs.deployit.engine.api.security.User;

/**
 * Manages users in Deployit's internal user repository. Use this service only if you're not connected to an external user repository like LDAP.
 */
@Path("/security/user")
@Consumes({MediaType.APPLICATION_XML})
@Produces({MediaType.APPLICATION_XML})
public interface UserService {

    /**
     * Creates a new user.
     *
     * @permission security#edit
     * @param username the login name
     * @param user the details of the user, containing username and new password. Username in here should be the same as the username in the URL path.
     * @return the created user, without the password.
     */
    @POST
    @Path("{username}")
    User create(@PathParam("username") String username, User user);

    /**
     * Returns the user details without the password.
     *
     * @permission security#edit
     * @param username the login name of the user.
     * @return the details of the user.
     */
    @GET
    @Path("{username}")
    User read(@PathParam("username") String username);

    /**
     * Changes the password of the indicated user.
     *
     * @permission security#edit
     * @param username the login name of the user.
     * @param user the details of the user, containing username and new password. Username in here should be the same as the username in the URL path.
     */
    @PUT
    @Path("{username}")
    void modifyPassword(@PathParam("username") String username, User user);

    /**
     * Deletes the user.
     *
     * @permission security#edit
     * @param username the login name of the user.
     */
    @DELETE
    @Path("{username}")
    void delete(@PathParam("username") String username);
}
