package com.xebialabs.deployit.engine.api.dto;

import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import org.jboss.resteasy.annotations.providers.multipart.PartType;

import javax.ws.rs.FormParam;
import javax.ws.rs.core.MediaType;

public class ArtifactAndData extends AbstractDto {

    @FormParam("configurationItem")
    @PartType(MediaType.APPLICATION_XML)
    private Artifact artifact;

    @FormParam("filename")
    @PartType(MediaType.APPLICATION_XML)
    private String filename;

    @FormParam("fileData")
    @PartType(MediaType.APPLICATION_OCTET_STREAM)
    private byte[] data;

    public ArtifactAndData() {

    }

    public ArtifactAndData(Artifact artifact, String filename, byte[] data) {
        this.artifact = artifact;
        this.filename = filename;
        this.data = data;
    }

    public ArtifactAndData(Artifact artifact, byte[] data) {
        this.artifact = artifact;
        this.data = data;
    }

    public Artifact getArtifact() {
        return artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(final byte[] data) {
        this.data = data;
    }

    public String getFilename() {
        return filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}
